%------------------------------------------------------------------------------
% File     : NUM815^5 : TPTP v7.4.0. Bugfixed v5.2.0.
% Domain   : Number Theory (Induction on naturals)
% Problem  : TPS problem from IND-THMS
% Version  : Especial.
% English  :

% Refs     : [Bro09] Brown (2009), Email to Geoff Sutcliffe
% Source   : [Bro09]
% Names    : tps_0773 [Bro09]

% Status   : Unknown
% Rating   : 1.00 v5.2.0
% Syntax   : Number of formulae    :    8 (   0 unit;   5 type;   2 defn)
%            Number of atoms       :   51 (   6 equality;  34 variable)
%            Maximal formula depth :   14 (   6 average)
%            Number of connectives :   36 (   0   ~;   0   |;   4   &;  29   @)
%                                         (   0 <=>;   3  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :   13 (  13   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :    7 (   5   :;   0   =)
%            Number of variables   :   13 (   0 sgn;   9   !;   1   ?;   3   ^)
%                                         (  13   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_UNK_EQU_NAR

% Comments : This problem is from the TPS library. Copyright (c) 2009 The TPS
%            project in the Department of Mathematical Sciences at Carnegie
%            Mellon University. Distributed under the Creative Commons copyleft
%            license: http://creativecommons.org/licenses/by-sa/3.0/
%          : 
% Bugfixes : v5.2.0 - Added missing type declarations.
%------------------------------------------------------------------------------
thf(c0_type,type,(
    c0: $i )).

thf(cPSI_type,type,(
    cPSI: $i > $i > $i )).

thf(cS_type,type,(
    cS: $i > $i )).

thf(cIND_type,type,(
    cIND: $o )).

thf(cPETER_INDEQS_type,type,(
    cPETER_INDEQS: $i > ( $i > $i ) > ( $i > $i > $i ) > $o )).

thf(cIND_def,definition,
    ( cIND
    = ( ! [Xp: $i > $o] :
          ( ( ( Xp @ c0 )
            & ! [Xx: $i] :
                ( ( Xp @ Xx )
               => ( Xp @ ( cS @ Xx ) ) ) )
         => ! [Xx: $i] :
              ( Xp @ Xx ) ) ) )).

thf(cPETER_INDEQS_def,definition,
    ( cPETER_INDEQS
    = ( ^ [X0: $i,S: $i > $i,PSI: $i > $i > $i] :
          ( ! [Xn: $i] :
              ( ( PSI @ X0 @ Xn )
              = ( S @ Xn ) )
          & ! [Xm: $i] :
              ( ( PSI @ ( S @ Xm ) @ X0 )
              = ( PSI @ Xm @ ( S @ X0 ) ) )
          & ! [Xm: $i,Xn: $i] :
              ( ( PSI @ ( S @ Xm ) @ ( S @ Xn ) )
              = ( PSI @ Xm @ ( PSI @ ( S @ Xm ) @ Xn ) ) ) ) ) )).

thf(cTHM585,conjecture,
    ( ( cIND
      & ( cPETER_INDEQS @ c0 @ cS @ cPSI ) )
   => ! [Xm: $i,Xn: $i] :
      ? [Xk: $i] :
        ( ( cPSI @ Xm @ Xn )
        = ( cS @ Xk ) ) )).

%------------------------------------------------------------------------------
